// RendererD3D11.h: interface for the CRendererD3D11 class.
//
// created by Unwinder
//////////////////////////////////////////////////////////////////////
#pragma once
//////////////////////////////////////////////////////////////////////
#include "Renderer.h"

#include <D3D11.h>
//////////////////////////////////////////////////////////////////////
class CRendererD3D11 : public CRenderer
{
public:
	virtual BOOL Init(HWND hWnd);
	virtual void Uninit();
	virtual void Reset(int x, int y);
	virtual void Render(DWORD dwColor);

	void InitRenderTarget();

	CRendererD3D11();
	virtual ~CRendererD3D11();

protected:
	HWND					m_hWnd;

	ID3D11Device*			m_lpd3dDevice; 
	ID3D11DeviceContext*	m_lpd3dDeviceContext; 
	ID3D11RenderTargetView* m_lpd3dRenderTarget;
	IDXGISwapChain*			m_lpSwapChain;
};
//////////////////////////////////////////////////////////////////////
